#Proyecto 1.2. Programo el cuadrado, programo el cuadrado

A) Construí un programa para dibujar dos cuadrados de color rojo, cada uno de tres bolitas 
   de lado, como muestra la figura. 
   ¿Te acordás de las actividades _“Lugar para los corners”_ y _“Programo el cuadrado”_? 
   Esta combina un poco de cada una. 

<center>
![Tablero final a producir, con 2 cuadrados de 3 bolitas de lado](data:image/png;base64,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)
</center>

Prestá atención a la celda donde tiene que terminar el cabezal. 
Esto te puede ayudar porque los dos cuadrados se pueden dibujar con instrucciones muy parecidas, 
si los dos se empiezan a dibujar desde la misma esquina... 

> **El dato**
>
> Antes de dibujar el segundo cuadrado deberías usar un par de veces el comando primitivo `Mover(Oeste)`.

B) Luego de guardar el programa en tu computadora, tratá de hacer un cambio. 
   ¿Cómo habría que modificar al programa para que dibuje los cuadrados un poco más grandes? 
   El resultado tiene que ser como la siguiente imagen.

<center>
![Tablero final a producir, con 2 cuadrados de 4 bolitas de lado](data:image/png;base64,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)
</center>

¿Fue muy difícil hacer el cambio? 
¿Te salió de una o tuviste que probar varias veces antes de conseguir que hiciera todo bien? 
¿Cuántos comandos primitivos tuviste que agregar y en qué lugares? 
¿Y si los cuadrados tuvieran que ocupar toda la altura del tablero, qué tan difícil sería hacer los cambios?
Acordate, al terminar, de volver a guardar tu solución con un nombre diferente al de antes.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/1.2.Programo%20el%20cuadrado%2C%20programo%20el%20cuadrado/assets/resources/description.pdf "Enunciado de 'Programo el cuadrado, programo el cuadrado' en PDF"
